/*
 * Decompiled with CFR 0.152.
 */
package com.ibm.hwmca.base.pa.ar;

import com.ibm.hwmca.base.pa.ar.MessageRefCodeMatch;
import com.ibm.hwmca.base.pa.ar.UniqueRefCodeRule;
import com.ibm.hwmca.base.pa.ar.UniqueRefCodeRuleBase;
import com.ibm.hwmca.fw.util.CommonXMLParser;
import com.ibm.hwmca.fw.util.MalformedXMLException;
import com.ibm.hwmca.fw.util.Trace;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.util.ArrayList;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.ErrorHandler;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import org.xml.sax.SAXNotRecognizedException;
import org.xml.sax.SAXNotSupportedException;
import org.xml.sax.SAXParseException;

public class UniqueRefCodeParser
extends CommonXMLParser
implements ErrorHandler {
    private static final String TRACE_MASKT = "XPALXMLT";
    private static final String TRACE_MASKF = "XPALXMLF";
    private static final String TRACE_MASKD = "XPALXMLD";
    private static final String TAG_HER_RULEBASE = "Hde-rulebase";
    private static final String TAG_HER_RULE = "Hde-rule";
    private static final String TAG_MESSAGES = "MESSAGES";
    private static final String TAG_REFCODE = "REFCODE";
    private static final String TAG_MESSAGE_NUMBER = "MESSAGE_NUMBER";
    private static final String TAG_TRUE = "TRUE";
    public static final String RULEBASE_ISC = "rulebase_isc.xml";
    public static final String xmlFile = "/home/dovin/javahmc/linuxhmc/data/pa/IQYP33AD.XML";

    public static void main(String[] args) {
        try {
            UniqueRefCodeRuleBase rb = UniqueRefCodeParser.parseXML(xmlFile);
            ArrayList allPossibleTokens = rb.getUniqueTokens();
            System.out.println("Unique message list and it's size is " + allPossibleTokens.size());
            for (int i = 0; i < allPossibleTokens.size(); ++i) {
                System.out.print("Messages Issued = ");
                for (int y = 0; y < ((MessageRefCodeMatch)allPossibleTokens.get(i)).getMessageList().size(); ++y) {
                    System.out.print(((MessageRefCodeMatch)allPossibleTokens.get(i)).getMessageList().get(y) + " ");
                }
                System.out.println();
                for (int x = 0; x < ((MessageRefCodeMatch)allPossibleTokens.get(i)).getRefcodes().size(); ++x) {
                    System.out.println(" refcode " + ((MessageRefCodeMatch)allPossibleTokens.get(i)).getRefcodes().get(x));
                    System.out.println(" cause " + ((MessageRefCodeMatch)allPossibleTokens.get(i)).getCauses().get(x));
                }
                System.out.println("**********************************");
            }
            System.out.println("done with rule");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        System.out.println("EXIT STAGE LEFT");
    }

    public UniqueRefCodeParser() throws SAXNotRecognizedException, SAXNotSupportedException {
        Trace.trace(TRACE_MASKD, "UniqueRefCodeParser.ctor");
    }

    public static UniqueRefCodeRuleBase parseXML(String fileName) throws MalformedXMLException {
        Trace.trace(TRACE_MASKT, "UniqueRefCodeParser.parseXML(" + fileName + ")");
        return UniqueRefCodeParser.parseXML(new File(fileName));
    }

    public static UniqueRefCodeRuleBase parseXML(File file) throws MalformedXMLException {
        Trace.trace(TRACE_MASKT, "HardwareEventParser.parseXML(" + file + ")");
        try {
            UniqueRefCodeParser parser = new UniqueRefCodeParser();
            if (parser != null) {
                Trace.trace(TRACE_MASKD, "acquired parser next open file " + file);
            } else {
                Trace.trace(TRACE_MASKD, "could not acquired parser");
            }
            InputSource xmlSource = new InputSource(new FileInputStream(file));
            if (xmlSource != null) {
                Trace.trace(TRACE_MASKD, "have a file");
            } else {
                Trace.trace(TRACE_MASKD, "could not acquired file");
            }
            parser.parse(xmlSource);
            Trace.trace(TRACE_MASKD, "parser.parse file");
            Document doc = parser.getDocument();
            if (doc != null) {
                Trace.trace(TRACE_MASKD, "got the Document");
            } else {
                Trace.trace(TRACE_MASKD, "no Document");
            }
            NodeList root = doc.getElementsByTagName(TAG_HER_RULEBASE);
            Trace.trace(TRACE_MASKD, "nodelist length" + root.getLength() + " what we looked for=" + TAG_HER_RULEBASE);
            UniqueRefCodeRuleBase rb = null;
            if (root.getLength() != 1) {
                Trace.trace(TRACE_MASKD, "too many Nodes");
                throw new MalformedXMLException("A single <Hde-rulebase> is expected.");
            }
            rb = UniqueRefCodeParser.parseRulebase(root.item(0));
            return rb;
        }
        catch (IOException e) {
            throw new MalformedXMLException("IOException reading file");
        }
        catch (ClassNotFoundException e) {
            throw new MalformedXMLException("ClassNotFoundException!");
        }
        catch (SAXParseException e) {
            throw new MalformedXMLException("SaxParseException! " + UniqueRefCodeParser.where(e));
        }
        catch (SAXException e) {
            throw new MalformedXMLException("SaxException! " + e);
        }
    }

    private static UniqueRefCodeRuleBase parseRulebase(Node node) throws ClassNotFoundException, MalformedXMLException {
        UniqueRefCodeRuleBase rb = new UniqueRefCodeRuleBase();
        NodeList children = node.getChildNodes();
        Trace.trace(TRACE_MASKD, "Children nodelist length = " + children.getLength());
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().toLowerCase().equals(TAG_HER_RULE.toLowerCase())) {
                rb.addRule(UniqueRefCodeParser.parseRule(child));
                Trace.trace(TRACE_MASKD, "Added rule");
                continue;
            }
            Trace.trace(TRACE_MASKD, "Error parsing HardwareEventRuleBase");
            throw new MalformedXMLException("Unknown tag ??? " + child.getNodeName().toLowerCase());
        }
        return rb;
    }

    private static UniqueRefCodeRule parseRule(Node node) throws ClassNotFoundException, MalformedXMLException {
        UniqueRefCodeRule rule = new UniqueRefCodeRule();
        NodeList children = node.getChildNodes();
        for (int i = 0; i < children.getLength(); ++i) {
            Node child = children.item(i);
            if (child.getNodeType() != 1) continue;
            if (child.getNodeName().equals(TAG_MESSAGES)) {
                rule.setMessages(UniqueRefCodeParser.gatherTextContents(child));
                continue;
            }
            if (child.getNodeName().equals(TAG_REFCODE)) {
                rule.setRefcode(UniqueRefCodeParser.gatherTextContents(child));
                continue;
            }
            if (!child.getNodeName().equals(TAG_MESSAGE_NUMBER)) continue;
            rule.setCause(UniqueRefCodeParser.gatherTextContents(child));
        }
        Trace.trace(TRACE_MASKD, "about to set rule.key");
        return rule;
    }

    private static ArrayList getArrayListOfMessages(String messageStr) {
        Trace.trace(TRACE_MASKD, "-->in getArrayListOfMessages " + messageStr);
        ArrayList<String> returnList = new ArrayList<String>();
        boolean finished = false;
        int i = 0;
        int comma = 0;
        messageStr = messageStr.trim();
        while (!finished) {
            comma = messageStr.indexOf(",", i);
            if (comma == -1) {
                finished = true;
                Trace.trace(TRACE_MASKD, "messageBeing Added " + messageStr.trim().substring(i + 1, messageStr.length() - 1));
                returnList.add(messageStr.trim().substring(i + 1, messageStr.length() - 1));
                continue;
            }
            Trace.trace(TRACE_MASKD, "messageBeing Added " + messageStr.trim().substring(i + 1, comma - 1));
            returnList.add(messageStr.trim().substring(i + 1, comma - 1));
            messageStr = messageStr.substring(comma + 1).trim();
            Trace.trace(TRACE_MASKD, "messageStr =  " + messageStr);
        }
        Trace.trace(TRACE_MASKD, "<-- getArrayListOfMessages " + returnList.size());
        return returnList;
    }

    public static ArrayList findTokensInMessage(String message, ArrayList allTokens) {
        int i;
        System.out.println("-->findTokensInMessage allTokenCount" + allTokens.size());
        ArrayList thisMessagesTokens = new ArrayList();
        for (i = 0; i < allTokens.size(); ++i) {
            if (message.indexOf((String)allTokens.get(i)) == -1 || thisMessagesTokens.contains((String)allTokens.get(i))) continue;
            thisMessagesTokens.add(allTokens.get(i));
        }
        System.out.println("thisMessagesTokens count=" + thisMessagesTokens.size());
        for (i = 0; i < thisMessagesTokens.size(); ++i) {
            System.out.println("token=" + thisMessagesTokens.get(i));
        }
        return thisMessagesTokens;
    }
}

